/*
 * Similarity.cpp
 *
 *  Created on: Nov 28, 2013
 *      Author: nino
 */

#include <Similarity.h>


double realization_similarity_phi( igraph_vector_t * realization1, igraph_vector_t * realization2, int phi_type, long int num_nodes){

	double tmpSim;

	if (phi_type == PHI_XNOR){
		long int tmpCount = realization_XNOR_fast( realization1, realization2);
		tmpSim = ( (double) tmpCount ) / ( (double) num_nodes );
	}else if (phi_type == PHI_JACCARD){
		tmpSim = realization_Jaccard( realization1, realization2);
	}else if ( phi_type == PHI_RAND){
		tmpSim = rand_sim();

	}else{
		printf("Wrong phi type \n");
		exit(-1);
	}

	return tmpSim;
}

double realization_similarity_phi_mask( igraph_vector_t * realization1, igraph_vector_t * realization2, igraph_vector_t * mask ,int phi_type, long int num_nodes){

	double tmpSim;

	if (phi_type == PHI_JACCARD){
		tmpSim = realization_Jaccard_mask( realization1, realization2, mask);
	}else{
		printf("Wrong phi type in realization_similarity_phi_mask() \n"); fflush(stdout);
		exit(-1);
	}

	return tmpSim;
}

long int realization_XNOR ( igraph_vector_t * realization1, igraph_vector_t * realization2){
	// moze se ubrzati sa xor i not i da se pipeliing iskoristi
	long int tmpCount = 0;
	for(int i=0; i < igraph_vector_size(realization1); ++i){
		if ( VECTOR(*realization1)[i] == VECTOR(*realization2)[i] ){
			++tmpCount;
		}
	}
	return tmpCount;
}


double realization_Jaccard ( igraph_vector_t * realization1, igraph_vector_t * realization2){

	long int num_and = realization_AND(realization1,realization2);
	long int num_or = realization_OR(realization1,realization2);
	double Jaccard_tmp = (double) num_and / (double) num_or;
	return Jaccard_tmp;
}

double realization_Jaccard_mask ( igraph_vector_t * realization1, igraph_vector_t * realization2, igraph_vector_t * mask){

	long int num_and = realization_AND_mask(realization1,realization2, mask);
	long int num_or = realization_OR_mask(realization1,realization2, mask);
	double Jaccard_tmp = (double) num_and / (double) num_or;
	return Jaccard_tmp;
}

double rand_sim() {
    double scale = RAND_MAX + 1.;
    double base = rand() / scale;
    double fine = rand() / scale;
    return base + fine / scale;
}

int realization_XNOR_fast ( igraph_vector_t * realization1, igraph_vector_t * realization2){
	unsigned int tmpCount = 0;
	for(int i=0; i < igraph_vector_size(realization1); ++i){
		tmpCount += ~(((unsigned int) VECTOR(*realization1)[i])^((unsigned int) VECTOR(*realization2)[i])) & 1;
		// bitwise not xor, not ( xor ) and last bit only
	}
	return (int) tmpCount;
}

long int realization_AND ( igraph_vector_t * realization1, igraph_vector_t * realization2){

	long int tmpCount = 0;
	for(int i=0; i < igraph_vector_size(realization1); ++i){
		if ( VECTOR(*realization1)[i] && VECTOR(*realization2)[i] ){
			++tmpCount;
		}
	}
	return tmpCount;
}

long int realization_AND_mask ( igraph_vector_t * realization1, igraph_vector_t * realization2, igraph_vector_t * mask){

	long int tmpCount = 0;
	for(int i=0; i < igraph_vector_size(realization1); ++i){
		if ( VECTOR(*realization1)[i] && VECTOR(*realization2)[i] && VECTOR(*mask)[i] ){
			++tmpCount;
		}
	}
	return tmpCount;
}

long int realization_OR ( igraph_vector_t * realization1, igraph_vector_t * realization2){

	long int tmpCount = 0;
	for(int i=0; i < igraph_vector_size(realization1); ++i){
		if ( VECTOR(*realization1)[i] || VECTOR(*realization2)[i] ){
			++tmpCount;
		}
	}
	return tmpCount;
}

long int realization_OR_mask ( igraph_vector_t * realization1, igraph_vector_t * realization2, igraph_vector_t * mask){

	long int tmpCount = 0;
	for(int i=0; i < igraph_vector_size(realization1); ++i){
		if (( VECTOR(*realization1)[i] || VECTOR(*realization2)[i] ) && VECTOR(*mask)[i]) {
			++tmpCount;
		}
	}
	return tmpCount;
}



int realization_identity(igraph_vector_t * realization1, igraph_vector_t * realization2){

	int indentity = 1;
	for(int i=0; i < igraph_vector_size(realization1); ++i){
		if ( VECTOR(*realization1)[i] == VECTOR(*realization2)[i] ){
			continue;
		}else{
			indentity = 0;
			break;
		}
	}
	return indentity;
}
